/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.popupevents.render;

import club.sk1er.popupevents.events.HypixelDuelRequestEvent;
import club.sk1er.popupevents.events.HypixelFriendRequestEvent;
import club.sk1er.popupevents.events.HypixelGuildInviteEvent;
import club.sk1er.popupevents.events.HypixelPartyInviteEvent;
import club.sk1er.popupevents.events.SkyblockTradeRequestEvent;
import java.awt.Color;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class ConfirmationPopup {
    private final Queue<Confirmation> confirmations = new LinkedList<Confirmation>();
    private Confirmation currentConfirmation;

    @SubscribeEvent
    public void friendRequest(HypixelFriendRequestEvent event) {
        this.displayConfirmation("Friend request from " + event.getFrom(), accept -> {
            FMLClientHandler.instance().getClient().field_71439_g.func_71165_d((accept != false ? "/friend accept " : "/friend deny ") + event.getFrom());
            this.currentConfirmation.framesLeft = 0L;
        });
    }

    @SubscribeEvent
    public void partyInvite(HypixelPartyInviteEvent event) {
        this.displayConfirmation("Party request from " + event.getFrom(), accept -> {
            FMLClientHandler.instance().getClient().field_71439_g.func_71165_d("/party accept " + event.getFrom());
            this.currentConfirmation.framesLeft = 0L;
        });
    }

    @SubscribeEvent
    public void tradeRequest(SkyblockTradeRequestEvent event) {
        this.displayConfirmation("Trade request from " + event.getUsername(), accept -> {
            FMLClientHandler.instance().getClient().field_71439_g.func_71165_d("/trade " + event.getUsername());
            this.currentConfirmation.framesLeft = 0L;
        });
    }

    @SubscribeEvent
    public void duelRequest(HypixelDuelRequestEvent event) {
        this.displayConfirmation(event.getGame() + " Duel request from " + event.getUsername(), accept -> {
            FMLClientHandler.instance().getClient().field_71439_g.func_71165_d("/duel accept " + event.getUsername());
            this.currentConfirmation.framesLeft = 0L;
        });
    }

    @SubscribeEvent
    public void guildInvite(HypixelGuildInviteEvent event) {
        this.displayConfirmation("Guild invite for " + event.getGuild(), accept -> {
            FMLClientHandler.instance().getClient().field_71439_g.func_71165_d("/guild accept " + event.getFrom());
            this.currentConfirmation.framesLeft = 0L;
        });
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (this.currentConfirmation == null) {
            this.currentConfirmation = this.confirmations.poll();
            return;
        }
        if (this.currentConfirmation.render()) {
            this.currentConfirmation = this.confirmations.poll();
        }
    }

    @SubscribeEvent
    public void keyPress(InputEvent.KeyInputEvent event) {
        if (this.currentConfirmation == null) {
            return;
        }
        if (Keyboard.getEventKey() == 21) {
            this.currentConfirmation.callback.accept(true);
        } else if (Keyboard.getEventKey() == 49) {
            this.currentConfirmation.callback.accept(false);
        }
    }

    private void displayConfirmation(String text, Consumer<Boolean> callback) {
        Confirmation confirmation = new Confirmation(300L, 300L, text, callback);
        this.confirmations.add(confirmation);
    }

    private static float clamp(float number) {
        return number < 0.0f ? 0.0f : Math.min(number, 1.0f);
    }

    private static float easeOut(float current, float goal) {
        if (Math.floor(Math.abs(goal - current) / 0.01f) > 0.0) {
            return current + (goal - current) / 15.0f;
        }
        return goal;
    }

    private static class Confirmation {
        private final String text;
        private final Consumer<Boolean> callback;
        private final long upperThreshold;
        private final long lowerThreshold;
        private long framesLeft;
        private float percentComplete;
        private long systemTime;

        Confirmation(long framesLeft, long frames, String text, Consumer<Boolean> callback) {
            this.text = text;
            this.callback = callback;
            this.framesLeft = framesLeft;
            long fifth = frames / 5L;
            this.upperThreshold = frames - fifth;
            this.lowerThreshold = fifth;
            this.percentComplete = 0.0f;
            FMLClientHandler.instance().getClient();
            this.systemTime = Minecraft.func_71386_F();
        }

        boolean render() {
            if (this.framesLeft <= 0L) {
                return true;
            }
            String acceptFrom = "";
            if (this.text.equalsIgnoreCase("Party request from " + acceptFrom)) {
                this.callback.accept(true);
                return true;
            }
            while (this.systemTime < Minecraft.func_71386_F() + 16L) {
                --this.framesLeft;
                this.systemTime += 16L;
            }
            this.percentComplete = ConfirmationPopup.clamp(ConfirmationPopup.easeOut(this.percentComplete, this.framesLeft < this.lowerThreshold ? 0.0f : (this.framesLeft > this.upperThreshold ? 1.0f : (float)this.framesLeft)));
            Minecraft client = FMLClientHandler.instance().getClient();
            FontRenderer fr = client.field_71466_p;
            ScaledResolution resolution = new ScaledResolution(client);
            int middle = resolution.func_78326_a() / 2;
            int halfWidth = 105;
            int currentWidth = (int)((float)halfWidth * this.percentComplete);
            Gui.func_73734_a((int)(middle - currentWidth), (int)50, (int)(middle + currentWidth), (int)95, (int)new Color(27, 27, 27).getRGB());
            if (this.percentComplete == 1.0f) {
                long length = this.upperThreshold - this.lowerThreshold;
                long current = this.framesLeft - this.lowerThreshold;
                float progress = 1.0f - ConfirmationPopup.clamp((float)current / (float)length);
                Gui.func_73734_a((int)(middle - currentWidth), (int)93, (int)((int)((float)(middle - currentWidth) + 210.0f * progress)), (int)95, (int)new Color(128, 226, 126).getRGB());
                fr.func_78276_b(this.text, resolution.func_78326_a() / 2 - fr.func_78256_a(this.text) / 2, 58, -1);
                String acceptDeny = EnumChatFormatting.GREEN + "[Y] Accept " + EnumChatFormatting.RED + "[N] Deny";
                fr.func_78276_b(acceptDeny, resolution.func_78326_a() / 2 - fr.func_78256_a(acceptDeny) / 2, 70, -1);
            }
            return false;
        }
    }
}

